#if NUNIT
#region Directives
//-----------------------***
using System;
using System.Collections;
using System.Data;
using System.Text;
using NUnit.Framework;
using gov.va.med.vbecs.UnitTests;

using TABLES = gov.va.med.vbecs.Common.VbecsTables;
using SPROCS = gov.va.med.vbecs.Common.VbecsStoredProcs;
using ARTIFICIAL = gov.va.med.vbecs.Common.DatabaseConstants.ArtificialColumnNames;


using BOL = gov.va.med.vbecs.BOL;
using COMMON = gov.va.med.vbecs.Common;
using DAL = gov.va.med.vbecs.DAL;
using VAL = gov.va.med.vbecs.VAL;
using gov.va.med.vbecs.VAL.UnitTests;
//-----------------------***
#endregion
namespace gov.va.med.vbecs.BOL.UnitTests
{

	
	

	[TestFixture]
	public class BOL_PatientAssignments : BaseTest 
	{

		private DataTable _dtBloodUnit;
		

		[SetUp]
		protected void SetUp()
		{
			this.BaseSetUp();

			if(this.RefreshData)
			{
				this._dtBloodUnit = UnitTestUtil.RunSQLGetDataTable("SELECT TOP 1 bum.BloodUnitGuid "+
							"FROM "+
							"	BloodUnitMedia bum "+
							"JOIN Patient p ON bum.DirectedPatientGuid=p.PatientGuid "+ 
							"JOIN BloodUnit bu on bum.BloodUnitGuid=bu.BloodUnitGuid "+	
							"WHERE bu.DivisionCode = '" + UnitTestConfig.TestDivisionCode + "' AND bu.RecordStatusCode = 'A'", true);

				this.RefreshData = false;
			}
		}

		[Test]
		public void GetPatientAssignments_Pass()
		{
			DataTable dtAsgns=BOL.PatientAssignments.GetPatientAssignments((System.Guid)_dtBloodUnit.Rows[0][TABLES.BloodUnit.BloodUnitGuid]);

			Assert.IsNotNull(dtAsgns);
		}

		[Test]
		public void GetPatientAssignments_Fail()
		{
			DataTable dtAsgns=BOL.PatientAssignments.GetPatientAssignments(System.Guid.Empty);

			Assert.IsNotNull(dtAsgns.Rows.Count<1);
		}

		[Test]
		public void GetPatientSpecimenAssignmentDetails_Pass()
		{
			DataTable dtAsgns=BOL.PatientAssignments.GetPatientSpecimenAssignmentDetails((System.Guid)_dtBloodUnit.Rows[0][TABLES.BloodUnit.BloodUnitGuid]);

			Assert.IsNotNull(dtAsgns);
		}

		[Test]
		public void GetPatientSpecimenAssignmentDetails_Fail()
		{
			DataTable dtAsgns=BOL.PatientAssignments.GetPatientSpecimenAssignmentDetails(System.Guid.Empty);

			Assert.IsNotNull(dtAsgns.Rows.Count<1);
		}
	}
}

#endif
